//Enhanced BApplication.  Provides facilities for registering windows and background
//threads and quits the application after the last window or thread is unregistered.

//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Argument and local variables - begin with a lowercase letter followed by
//        lowercase words separated by underscores.
//        (E.G., int my_local;).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


#ifndef _SGB_DOCUMENT_APP_H_
#define _SGB_DOCUMENT_APP_H_


//******************************************************************************************************
//**** SYSTEM HEADER FILES
//******************************************************************************************************
#include <Application.h>


//******************************************************************************************************
//**** CLASS DECLARATIONS
//******************************************************************************************************
class DocumentApp : public BApplication
{
	public:
		DocumentApp(const char* a_signature);
		~DocumentApp();
		virtual bool QuitRequested();
			//If you override QuitRequested, make sure to call DocumentApp::QuitRequested()
			//if you intend to use FileDocumentWindow.
		void CancelQuitProcess();
		bool IsQuitInProgress();
		void RegisterWindow();
		void UnregisterWindow();
		void ProcessHold();
		void ProcessDone();
		int32 CountRegWindProcHolds();		//Returns the number of registered windows
											//and process holds

	private:
		int32 m_window_and_process_holds;
		bool m_quit_process;
};


#endif